function femmodel=enthalpy_core(femmodel)
%ENTHALPY_CORE - core of enthalpy solution
%
%   Usage:
%      femmodel=enthalpy_core(femmodel)


	%recover parameters common to all solutions
	ndt=femmodel.parameters.TimesteppingFinalTime;
	dt=femmodel.parameters.TimesteppingTimeStep;
	control_analysis=femmodel.parameters.InversionIscontrol;
	solution_type=femmodel.parameters.SolutionType;

	%Compute number of timesteps
	if (dt==0 | ndt==0),
		dt=0;
		nsteps=1;
	else
		nsteps=floor(ndt/dt);
	end

	%Loop through time
	for i=1:nsteps,
		issmprintf(VerboseSolution,'\n%s%i/%i\n','time step: ',i,nsteps);
		time=(i+1)*dt;

		issmprintf(VerboseSolution,'\n%s',['   computing enthalpy']);
		femmodel=SetCurrentConfiguration(femmodel,EnthalpyAnalysisEnum);
		femmodel=solver_linear(femmodel);

		if (solution_type==EnthalpySolutionEnum & ~control_analysis),
			issmprintf(VerboseSolution,'\n%s',['   saving results']);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,EnthalpyEnum,i,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,TemperatureEnum,i,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,WaterFractionEnum,i,time);
		end
	end

end %end of function
