function femmodel=bedslope_core(femmodel)
%BEDSLOPE_CORE - core of the bed slope computation solution
%
%   Usage:
%      femmodel=bedslope_core(femmodel)
%

	%Recover some parameters:
	dim=femmodel.parameters.Dim;
	control_analysis=femmodel.parameters.InversionIscontrol;
	solution_type=femmodel.parameters.SolutionType;

	issmprintf(VerboseSolution,'   computing bed slope');

	%Call on core computations: 
	femmodel=SetCurrentConfiguration(femmodel,BedSlopeAnalysisEnum,BedSlopeXAnalysisEnum);
	femmodel=solver_linear(femmodel);
	femmodel=SetCurrentConfiguration(femmodel,BedSlopeAnalysisEnum,BedSlopeYAnalysisEnum);
	femmodel=solver_linear(femmodel);
	
	if (solution_type==BedSlopeSolutionEnum & ~control_analysis),
		issmprintf(VerboseSolution,'   saving results');
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,BedSlopeXEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,BedSlopeYEnum);
	end
