function femmodel=balancethickness_core(femmodel)
%BALANCEDTHICKNESS_CORE - linear solution sequence
%
%   Usage:
%      femmodel=balancethickness_core(femmode)

	%recover parameters common to all solutions
	dim=femmodel.parameters.Dim;
	control_analysis=femmodel.parameters.InversionIscontrol;
	solution_type=femmodel.parameters.SolutionType;

	%Activate formulation
	femmodel=SetCurrentConfiguration(femmodel,BalancethicknessAnalysisEnum);

	issmprintf(VerboseSolution,'   call computational core');
	femmodel=solver_linear(femmodel);

	if (solution_type==BalancethicknessSolutionEnum & ~control_analysis),
		issmprintf(VerboseSolution,'   saving results');
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,ThicknessEnum);
	end
	
end %end function
