/*!\file: balancethickness_core.cpp
 * \brief: core of the balancethickness solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void balancethickness_core(FemModel* femmodel){

	/*parameters: */
	int  dim;
	int  solution_type;
	bool control_analysis;

	/*activate formulation: */
	femmodel->SetCurrentConfiguration(BalancethicknessAnalysisEnum);
	
	/*recover parameters: */
	femmodel->parameters->FindParam(&dim,DimEnum);
	femmodel->parameters->FindParam(&control_analysis,InversionIscontrolEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	_printf_(VerboseSolution(),"call computational core:\n");
	solver_linear(femmodel);

	if(solution_type==BalancethicknessSolutionEnum && !control_analysis){
		_printf_(VerboseSolution(),"   saving results\n");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ThicknessEnum);
	}

}
