/*\file EnumToModelField.cpp:
* \brief: output string associated with enum, that corresponds  to a model field
* for example: ThicknessEnum corresponds to model field thickness
*              FrictionCoefficientEnum corresponds to model field drag
*/

#include "../shared/shared.h"
#include "../include/include.h"
#include "./EnumDefinitions.h"

char* EnumToModelField(int en){

	switch(en){

		case ThicknessEnum : return "thickness";
		case FrictionCoefficientEnum : return "drag_coefficient";
		case MaterialsRheologyBEnum : return "rheology_B";
		case MaterialsRheologyBbarEnum : return "rheology_B";
		case BalancethicknessThickeningRateEnum: return "dhdt";
		case VxEnum : return "vx";
		case InversionVxObsEnum : return "vx_obs";
		case VyEnum : return "vy";
		case InversionVyObsEnum : return "vy_obs";
		case BasalforcingsMeltingRateEnum : return "basal_melting_rate";
      case SurfaceforcingsAccumulationRateEnum : return "surface_accumulation_rate";
		case SurfaceforcingsAblationRateEnum : return "surface_ablation_rate";
		case SurfaceforcingsMassBalanceEnum : return "surface_mass_balance";
		default : _error_("No model field is associated to enum %s",EnumToStringx(en));
	}
}
