function displaybc(md)
%DISPLAYBC - display of the boundary conditions fileds
%
%   to avoid clobbering display.m with every field from model md, 
%   we create this routine that displays boundary conditions  from model md, 
%   only if requested.
%
%   Usage:
%      displaybc(md)

disp(sprintf('   Boundary conditions:'));

disp(sprintf('\n      diagnostic:'));
fielddisplay(md,'diagnostic.spcvx','x-axis velocity constraint (NaN means no constraint)');
fielddisplay(md,'diagnostic.spcvy','y-axis velocity constraint (NaN means no constraint)');
fielddisplay(md,'diagnostic.spcvz','z-axis velocity constraint (NaN means no constraint)');
fielddisplay(md,'pressureload','segments on ice front list (0:Air 1:Water 2:Ice)');

disp(sprintf('\n      prognostic:'));
fielddisplay(md,'spcthickness','thickness constraints (NaN means no constraint)');

disp(sprintf('\n      thermal:'));
fielddisplay(md,'spctemperature','temperature constraints (NaN means no constraint)');
