md=mesh(model,'../Exp/Square.exp',150000);
md=meshconvert(md);
md=setmask(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.par');
md=setflowequation(md,'macayeal','all');
md.prognostic.stabilization=3;
md.prognostic.spcthickness=md.thickness;
md.cluster=none;
md=solve(md,PrognosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Thickness'};
field_tolerances={1e-13};
field_values={...
	PatchToVec(md.results.PrognosticSolution.Thickness),...
	};
