md=mesh(model,'../Exp/Square.exp',150000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setflowequation(md,'macayeal','all');
md.bed=md.bed+50; md.surface=md.surface+50;
md.cluster=none;
md.prognostic.hydrostatic_adjustment='Incremental';
md=solve(md,TransientSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx1','Vy1','Vel1','Pressure1','Bed1','Surface1','Thickness1','Vx2','Vy2','Vel2','Pressure2','Bed2','Surface2','Thickness2','Vx3','Vy3','Vel3','Pressure3','Bed3','Surface3','Thickness3'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	PatchToVec(md.results.TransientSolution(1).Vx),...
	PatchToVec(md.results.TransientSolution(1).Vy),...
	PatchToVec(md.results.TransientSolution(1).Vel),...
	PatchToVec(md.results.TransientSolution(1).Pressure),...
	PatchToVec(md.results.TransientSolution(1).Bed),...
	PatchToVec(md.results.TransientSolution(1).Surface),...
	PatchToVec(md.results.TransientSolution(1).Thickness),...
	PatchToVec(md.results.TransientSolution(2).Vx),...
	PatchToVec(md.results.TransientSolution(2).Vy),...
	PatchToVec(md.results.TransientSolution(2).Vel),...
	PatchToVec(md.results.TransientSolution(2).Pressure),...
	PatchToVec(md.results.TransientSolution(2).Bed),...
	PatchToVec(md.results.TransientSolution(2).Surface),...
	PatchToVec(md.results.TransientSolution(2).Thickness),...
	PatchToVec(md.results.TransientSolution(3).Vx),...
	PatchToVec(md.results.TransientSolution(3).Vy),...
	PatchToVec(md.results.TransientSolution(3).Vel),...
	PatchToVec(md.results.TransientSolution(3).Pressure),...
	PatchToVec(md.results.TransientSolution(3).Bed),...
	PatchToVec(md.results.TransientSolution(3).Surface),...
	PatchToVec(md.results.TransientSolution(3).Thickness),...
	};
