md=mesh(model,'../Exp/Square.exp',150000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
%Add boundary conditions on thickness on the border
pos=find(md.nodeonboundary);
md.balancethickness.spcthickness(pos)=md.thickness(pos);
md=setflowequation(md,'macayeal','all');
md.cluster=none;
md=solve(md,BalancethicknessSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Thickness'};
field_tolerances={1e-13};
field_values={...
	PatchToVec(md.results.BalancethicknessSolution.Thickness),...
	};
