md=mesh(model,'../Exp/Square.exp',120000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=extrude(md,2,1);
md=setflowequation(md,'stokes','../Exp/SquareHalfRight.exp','fill','pattyn');
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure'};
field_tolerances={1e-09,1e-09,1e-06,1e-09,1e-09};
field_values={...
	PatchToVec(md.results.DiagnosticSolution.Vx),...
	PatchToVec(md.results.DiagnosticSolution.Vy),...
	PatchToVec(md.results.DiagnosticSolution.Vz),...
	PatchToVec(md.results.DiagnosticSolution.Vel),...
	PatchToVec(md.results.DiagnosticSolution.Pressure),...
	};
