md=mesh(model,'../Exp/Square.exp',200000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=extrude(md,3,1);
md=setflowequation(md,'stokes','all');

%control parameters
md.control_analysis=1;
md.control_type={'MaterialsRheologyBbar'};
md.cm_min=10^6*ones(md.numberofnodes,1);
md.cm_max=2*10^9*ones(md.numberofnodes,1);
md.nsteps=2;
md.cm_responses=101*ones(md.nsteps,1);
md.weights=ones(md.numberofnodes,1);
md.optscal=10^7*ones(md.nsteps,1);
md.maxiter=2*ones(md.nsteps,1);
md.cm_jump=0.3*ones(md.nsteps,1);
md.vx_obs=md.vx; md.vy_obs=md.vy;

md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Gradient' 'Misfits' 'MaterialsRheologyBbar' 'Pressure' 'Vel' 'Vx' 'Vy'};
field_tolerances={1e-08,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09};
field_values={...
	PatchToVec(md.results.DiagnosticSolution.Gradient1),...
	md.results.DiagnosticSolution.J,...
	PatchToVec(md.results.DiagnosticSolution.MaterialsRheologyB),...
	PatchToVec(md.results.DiagnosticSolution.Pressure),...
	PatchToVec(md.results.DiagnosticSolution.Vel),...
	PatchToVec(md.results.DiagnosticSolution.Vx),...
	PatchToVec(md.results.DiagnosticSolution.Vy)
};
