md=mesh(model,'../Exp/Square.exp',180000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=extrude(md,3,1);
md=setflowequation(md,'macayeal','all');
md.timestepping.time_step=0;
md.cluster=none;
md=solve(md,ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature','BasalforcingsMeltingRate'};
field_tolerances={1e-13,1e-13};
field_values={...
	PatchToVec(md.results.ThermalSolution.Temperature),...
	PatchToVec(md.results.ThermalSolution.BasalforcingsMeltingRate),...
	};
