function md=solveparallel(md,options)
%SOLVEPARALLEL - solution sequence using a cluster in parallel mode
%
%   Usage:
%      md=solveparallel(md);

%Get cluster.rc location
cluster_rc_location=which('cluster.rc');

%Figure out parameters for this particular cluster
[codepath,executionpath]=ClusterParameters(md.cluster,cluster_rc_location);

%Marshall model data into a binary file.
marshall(md);

%add qmu fields to binary file if running qmu analysis
if md.qmu_analysis,
	qmumarshall(md,md.variables(options.ivar),md.responses(options.iresp));
end

%Now, we need to build the queuing script, used by the cluster to launch the job.
BuildQueueingScript(md,executionpath,codepath);

%Now, launch the queueing script
LaunchQueueJob(md,executionpath);

%Do we return, or just wait for results?
if md.waitonlock,
	%we wait for the done file
	waitonlock([executionpath '/' md.name '.lock']);
	%load results
	md=loadresultsfromcluster(md);
end
