%QMU class definition
%
%   Usage:
%      qmu=qmu();

classdef qmu
	properties (SetAccess=public) 
		variables                   = modelfield('default',struct(),'marshall',false);
		responses                   = modelfield('default',struct(),'marshall',false);
		method                      = modelfield('default',struct(),'marshall',false);
		params                      = modelfield('default',struct(),'marshall',false);
		results                     = modelfield('default',struct(),'marshall',false);
		isdakota                    = modelfield('default',0,'marshall',true,'format','Boolean');
		partition                   = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',2);
		numberofpartitions          = modelfield('default',0,'marshall',true,'format','Integer');
		numberofresponses           = modelfield('default',0,'marshall',true,'format','Integer');
		variabledescriptors         = modelfield('default',{},'marshall',true,'format','StringArray');
		responsedescriptors         = modelfield('default',{},'marshall',true,'format','StringArray');
		mass_flux_profile_directory = modelfield('default',NaN,'marshall',false);
		mass_flux_profiles          = modelfield('default',NaN,'marshall',false);
		mass_flux_segments          = modelfield('default',{},'marshall',true,'format','MatArray');
		adjacency                   = modelfield('default',NaN,'marshall',false);
		vertex_weight               = modelfield('default',NaN,'marshall',false);
	end
	methods
		function obj = qmu(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end
		end % }}}
		function disp(obj) % {{{

			fielddisplay(obj,'isdakota','is qmu analysis activated?');

			for i=1:numel(obj.variables)
				disp(sprintf('         variables%s:  (arrays of each variable class)',...
					string_dim(obj.variables,i)));
				fnames=fieldnames(obj.variables(i));
				maxlen=0;
				for j=1:numel(fnames)
					maxlen=max(maxlen,length(fnames{j}));
				end

				for j=1:numel(fnames)
					disp(sprintf(['            %-' num2str(maxlen+1) 's:    [%ix%i]    ''%s'''],...
						fnames{j},size(obj.variables.(fnames{j})),class(obj.variables.(fnames{j}))));
				end
			end


			for i=1:numel(obj.responses)
				disp(sprintf('         responses%s:  (arrays of each response class)',...
					string_dim(obj.responses,i)));
				fnames=fieldnames(obj.responses(i));
				maxlen=0;
				for j=1:numel(fnames)
					maxlen=max(maxlen,length(fnames{j}));
				end

				for j=1:numel(fnames)
					disp(sprintf(['            %-' num2str(maxlen+1) 's:    [%ix%i]    ''%s'''],...
						fnames{j},size(obj.responses.(fnames{j})),class(obj.responses.(fnames{j}))));
				end
			end


			disp(sprintf('         qmu_method:  (array of dakota_method class)'));
			for i=1:numel(obj.qmu_method);
				if strcmp(class(obj.qmu_method(i)),'dakota_method')
					disp(sprintf('            method%s :    ''%s''',...
						string_dim(obj.qmu_method,i),obj.qmu_method(i).method));
				end
			end

			for i=1:numel(obj.qmu_params)
				disp(sprintf('         qmu_params%s:  (array of method-independent parameters)',...
					string_dim(obj.qmu_params,i)));
				fnames=fieldnames(obj.qmu_params(i));
				maxlen=0;
				for j=1:numel(fnames)
					maxlen=max(maxlen,length(fnames{j}));
				end

				for j=1:numel(fnames)
					disp(sprintf(['            %-' num2str(maxlen+1) 's: %s'],...
						fnames{j},any2str(obj.qmu_params(i).(fnames{j}))));
				end
			end

			for i=1:numel(obj.dakotaresults)
				disp(sprintf('         dakotaresults%s:  (information from dakota files)',...
					string_dim(obj.dakotaresults,i)));
				fnames=fieldnames(obj.dakotaresults(i));
				maxlen=0;
				for j=1:numel(fnames)
					maxlen=max(maxlen,length(fnames{j}));
				end

				for j=1:numel(fnames)
					disp(sprintf(['            %-' num2str(maxlen+1) 's:    [%ix%i]    ''%s'''],...
						fnames{j},size(obj.dakotaresults.(fnames{j})),class(obj.dakotaresults.(fnames{j}))));
				end
			end

			disp(sprintf('         npart   : %i (number of partitions for semi-descrete qmu)',obj.npart));
			disp(sprintf('         part    : [%i] (user provided mesh partition, defaults to metis if not specified)',length(obj.part)));
		end % }}}
	end
end
