%BALANCETHICKNESS class definition
%
%   Usage:
%      balancethickness=balancethickness();

classdef balancethickness
	properties (SetAccess=public) 
		spcthickness      = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		thickening_rate   = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		stabilization     = modelfield('default',0,'marshall',true,'format','Integer');
		requested_outputs = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',3);
	end
	methods
		function obj = balancethickness(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

			%Type of stabilization used
			obj.stabilization=1;

		end % }}}
	end
end
