#include "../../../Container/Container.h"
#include "../../../modules/modules.h"
#include "../../../io/io.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsBalancethickness(Constraints** pconstraints, IoModel* iomodel){

	int    stabilization;	
	
	/*Fetch parameters: */
	iomodel->Constant(&stabilization,BalancethicknessStabilizationEnum);

	/*Output*/
	Constraints* constraints = NULL;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);

	/*Do not add constraints in DG*/
	if(!stabilization==3){
		IoModelToConstraintsx(constraints,iomodel,BalancethicknessSpcthicknessEnum,BalancethicknessAnalysisEnum);
	}

	/*Assign output pointer: */
	*pconstraints=constraints;
}
