md=mesh(model,'../Exp/79North.exp',10000);
md=meshconvert(md);
md=setmask(md,'../Exp/79NorthShelf.exp','');
md=parameterize(md,'../Par/79North.par');
md=setelementstype(md,'macayeal','all');

%Ice sheet only
md=modelextract(md,md.mask.elementongroundedice);
pos=find(md.nodeonboundary);
md.balancethickness.spcthickness(pos)=md.thickness(pos);

%control parameters
md.thickness_obs=md.thickness;
md.control_analysis=1;
md.thickness_obs=md.thickness;
md.nsteps=2;
md.control_type={'Vx' 'Vy'};
md.prognostic.stabilization=1;
md.optscal=[10/md.constants.yts*ones(md.nsteps,1) 10/md.constants.yts*ones(md.nsteps,1)];
md.cm_min=[-2000*ones(md.numberofnodes,1) -2000*ones(md.numberofnodes,1)];
md.cm_max=[+2000*ones(md.numberofnodes,1) +2000*ones(md.numberofnodes,1)];
md.cm_responses=201*ones(md.nsteps,1);
md.weights=ones(md.numberofnodes,1);
md.maxiter=4*ones(md.nsteps,1);
md.cm_jump=0.99*ones(md.nsteps,1);

md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,BalancethicknessSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Gradient1' 'Gradient2' 'Misfits' 'Vx' 'Vy' 'Thickness'};
field_tolerances={1e-12,1e-12,1e-12,1e-12,1e-12,1e-12};
field_values={...
	PatchToVec(md.results.BalancethicknessSolution.Gradient1),...
	PatchToVec(md.results.BalancethicknessSolution.Gradient2),...
	md.results.BalancethicknessSolution.J,...
	PatchToVec(md.results.BalancethicknessSolution.Vx),...
	PatchToVec(md.results.BalancethicknessSolution.Vy),...
	PatchToVec(md.results.BalancethicknessSolution.Thickness)
};
