%MASK class definition
%
%   Usage:
%      mask=mask();

classdef mask
	properties (SetAccess=public) 
		elementonfloatingice = modelfield('default',NaN,'marshall',true,'format','BooleanMat','mattype',2);
		elementongroundedice = modelfield('default',NaN,'marshall',true,'format','BooleanMat','mattype',2);
		elementonwater       = modelfield('default',NaN,'marshall',true,'format','BooleanMat','mattype',2);
		vertexonfloatingice  = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		vertexongroundedice  = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		vertexonwater        = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
	end
	methods
		function obj = mask(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

		end % }}}
		function disp(obj) % {{{

			fielddisplay(md,'elementonfloatingice','element on floating ice flags list');
			fielddisplay(md,'vertexonfloatingice','vertex on floating ice flags list');
			fielddisplay(md,'elementongroundedice','element on grounded ice  list');
			fielddisplay(md,'vertexongroundedice','vertex on grounded ice flags list');
			fielddisplay(md,'elementonwater','element on water flags list');
			fielddisplay(md,'vertexonwater','vertex on water flags list');
		end % }}}
	end
end
