md=mesh(model,'../Exp/Square.exp',200000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=extrude(md,3,1);
md=setelementstype(md,'pattyn','all');
md.cluster=generic('name',oshostname(),'np',3);
md.prognostic.prognostic.hydrostatic_adjustment='Incremental';
md=solve(md,TransientSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx1','Vy1','Vz1','Vel1','Pressure1','Bed1','Surface1','Thickness1','Temperature1','BasalforcingsMeltingRate1', ...
				      'Vx2','Vy2','Vz2','Vel2','Pressure2','Bed2','Surface2','Thickness2','Temperature2','BasalforcingsMeltingRate2', ...
					   'Vx3','Vy3','Vz3','Vel3','Pressure3','Bed3','Surface3','Thickness3','Temperature3','BasalforcingsMeltingRate3'};
field_tolerances={...
	1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,...
	1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,...
	1e-09,1e-09,1e-08,1e-08,1e-09,1e-09,1e-09,1e-09,1e-09,1e-05};
field_values={...
	PatchToVec(md.results.TransientSolution(1).Vx),...
	PatchToVec(md.results.TransientSolution(1).Vy),...
	PatchToVec(md.results.TransientSolution(1).Vz),...
	PatchToVec(md.results.TransientSolution(1).Vel),...
	PatchToVec(md.results.TransientSolution(1).Pressure),...
	PatchToVec(md.results.TransientSolution(1).Bed),...
	PatchToVec(md.results.TransientSolution(1).Surface),...
	PatchToVec(md.results.TransientSolution(1).Thickness),...
	PatchToVec(md.results.TransientSolution(1).Temperature),...
	PatchToVec(md.results.TransientSolution(1).BasalforcingsMeltingRate),...
	PatchToVec(md.results.TransientSolution(2).Vx),...
	PatchToVec(md.results.TransientSolution(2).Vy),...
	PatchToVec(md.results.TransientSolution(2).Vz),...
	PatchToVec(md.results.TransientSolution(2).Vel),...
	PatchToVec(md.results.TransientSolution(2).Pressure),...
	PatchToVec(md.results.TransientSolution(2).Bed),...
	PatchToVec(md.results.TransientSolution(2).Surface),...
	PatchToVec(md.results.TransientSolution(2).Thickness),...
	PatchToVec(md.results.TransientSolution(2).Temperature),...
	PatchToVec(md.results.TransientSolution(2).BasalforcingsMeltingRate),...
	PatchToVec(md.results.TransientSolution(3).Vx),...
	PatchToVec(md.results.TransientSolution(3).Vy),...
	PatchToVec(md.results.TransientSolution(3).Vz),...
	PatchToVec(md.results.TransientSolution(3).Vel),...
	PatchToVec(md.results.TransientSolution(3).Pressure),...
	PatchToVec(md.results.TransientSolution(3).Bed),...
	PatchToVec(md.results.TransientSolution(3).Surface),...
	PatchToVec(md.results.TransientSolution(3).Thickness),...
	PatchToVec(md.results.TransientSolution(3).Temperature),...
	PatchToVec(md.results.TransientSolution(3).BasalforcingsMeltingRate),...
	};
