%PROGNOSTIC class definition
%
%   Usage:
%      prognostic=prognostic();

classdef prognostic
	properties (SetAccess=public) 
		 spcthickness           = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		 hydrostatic_adjustment = modelfield('default',0,'marshall',true,'preprocess','StringToEnum','format','Integer');
		 stabilization          = modelfield('default',0,'marshall',true,'format','Integer');
		 vertex_pairing         = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',3);
		 penalty_factor         = modelfield('default',0,'marshall',true,'format','Double');
		 requested_outputs      = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',3);
	end
	methods
		function obj = prognostic(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

			%Type of stabilization to use 0:nothing 1:artificial_diffusivity 3:Discontinuous Galerkin
			obj.stabilization=1;

			%Factor applied to compute the penalties kappa=max(stiffness matrix)*10^penalty_factor
			obj.penalty_factor=3;

			%Hydrostatic adjustment
			obj.hydrostatic_adjustment='Absolute';
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   Prognostic solution parameters:'));

			disp(sprintf('\n      transient:'));
			fielddisplay(obj,'stabilization','0->no, 1->artificial_diffusivity, 3-:discontinuous Galerkin');

			disp(sprintf('\n      boundary conditions:'));
			fielddisplay(obj,'spcthickness','thickness constraints (NaN means no constraint)');

		end % }}}
	end
end
