#include "../../../Container/Container.h"
#include "../../../modules/modules.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../io/io.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsPrognostic(Constraints** pconstraints, IoModel* iomodel){

	int stabilization;
	
	/*Fetch parameters: */
	iomodel->Constant(&stabilization,PrognosticStabilizationEnum);

	/*Output*/
	Constraints *constraints = NULL;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);

	/*Do not add constraints in DG, they are weakly imposed*/
	if(!stabilization==3){
		IoModelToConstraintsx(constraints,iomodel,PrognosticSpcthicknessEnum,PrognosticAnalysisEnum);
	}

	/*Assign output pointer: */
	*pconstraints=constraints;
}
