function md=SetIceSheetBC(md)
%SETICESHEETBC - Create the boundary conditions for diagnostic and thermal models for an IceSheet with no Ice Front
%
%   Usage:
%      md=SetIceSheetBC(md)
%
%   See also: SETICESHELFBC, SETMARINEICESHEETBC

%node on Dirichlet
pos=find(md.nodeonboundary);
md.spcvx=NaN*ones(md.numberofnodes,1);
md.spcvy=NaN*ones(md.numberofnodes,1);
md.spcvz=NaN*ones(md.numberofnodes,1);
md.spcvx(pos)=0;
md.spcvy(pos)=0;
md.spcvz(pos)=0;
md.diagnostic_ref=NaN*ones(md.numberofnodes,6);

%Dirichlet Values
if (length(md.vx_obs)==md.numberofnodes & length(md.vy_obs)==md.numberofnodes)
	disp('      boundary conditions for diagnostic model: spc set as observed velocities');
	md.spcvx(pos)=md.vx_obs(pos);
	md.spcvy(pos)=md.vy_obs(pos);
else
	disp('      boundary conditions for diagnostic model: spc set as zero');
end

%segment on neumann (Ice Front) -> none
if (md.dim==2)
	md.pressureload=zeros(0,4);
else
	md.pressureload=zeros(0,6);
end

%Create zeros basal melting rate and surface mass balance if not specified
if isnan(md.surfaceforcings.accumulation_rate),
	md.surfaceforcings.accumulation_rate=zeros(md.numberofnodes,1);
	disp('      no surfaceforcings.accumulation_rate specified: values set as zero');
end
if isnan(md.surfaceforcings.ablation_rate),
	md.surfaceforcings.ablation_rate=zeros(md.numberofnodes,1);
	disp('      no surfaceforcings.ablation_rate specified: values set as zero');
end
if isnan(md.surfaceforcings.mass_balance),
	md.surfaceforcings.mass_balance=zeros(md.numberofnodes,1);
	disp('      no surfaceforcings.mass_balance specified: values set as zero');
end
if isnan(md.basalforcings.melting_rate),
	md.basalforcings.melting_rate=zeros(md.numberofnodes,1);
	disp('      no basalforcings.melting_rate specified: values set as zero');
end
if isnan(md.dhdt),
	md.dhdt=zeros(md.numberofnodes,1);
	disp('      no dhdt specified: values set as zero');
end

md.prognostic.spcthickness=NaN*ones(md.numberofnodes,1);

if (length(md.temperature)==md.numberofnodes),
	md.thermal.spctemperature=NaN*ones(md.numberofnodes,1);
	pos=find(md.nodeonsurface); md.thermal.spctemperature(pos)=md.temperature(pos); %impose observed temperature on surface
	if (length(md.basalforcings.geothermalflux)~=md.numberofnodes),
		md.basalforcings.geothermalflux=50*10^-3*ones(md.numberofnodes,1); %50 mW/m^2
	end
else
	disp('      no thermal boundary conditions created: no observed temperature found');
end
