function md=collapse(md)
%COLLAPSE - collapses a 3d mesh into a 2d mesh
%
%   This routine collapses a 3d model into a 2d model
%   and collapses all the fileds of the 3d model by
%   taking their depth-averaged values
%
%   Usage:
%      md=collapse(md)
%
%   See also: EXTRUDE, MODELEXTRACT

%Check that the model is really a 3d model
if ~md.dim==3,
	error('collapse error message: only 3d mesh can be collapsed')
end

%Start with changing alle the fields from the 3d mesh 

%drag is limited to nodes that are on the bedrock.
md.friction.coefficient=project2d(md,md.friction.coefficient,1);

%p and q (same deal, except for element that are on the bedrock: )
md.friction.p=project2d(md,md.friction.p,1);
md.friction.q=project2d(md,md.friction.q,1);

%observations
if ~isnan(md.vx_obs), md.vx_obs=project2d(md,md.vx_obs,md.numlayers); end;
if ~isnan(md.vy_obs), md.vy_obs=project2d(md,md.vy_obs,md.numlayers); end;
if ~isnan(md.vel_obs), md.vel_obs=project2d(md,md.vel_obs,md.numlayers); end;
if ~isnan(md.surfaceforcings.mass_balance),
	md.surfaceforcings.mass_balance=project2d(md,md.surfaceforcings.mass_balance,md.numlayers); 
end;
if ~isnan(md.dhdt), md.dhdt=project2d(md,md.dhdt,md.numlayers); end;

%results
if ~isnan(md.vx),md.vx=DepthAverage(md,md.vx);end;
if ~isnan(md.vy),md.vy=DepthAverage(md,md.vy);end;
if ~isnan(md.vz),md.vz=DepthAverage(md,md.vz);end;
if ~isnan(md.vel),md.vel=DepthAverage(md,md.vel);end;

%bedinfo and surface info
md.elementonbed=ones(md.numberofelements2d,1);
md.elementonsurface=ones(md.numberofelements2d,1);
md.nodeonbed=ones(md.numberofnodes2d,1);
md.nodeonsurface=ones(md.numberofnodes2d,1);

%elementstype
if ~isnan(md.elements_type)
	md.elements_type=project2d(md,md.elements_type,1);
end	
md.nodeonhutter=project2d(md,md.nodeonhutter,1);
md.nodeonmacayeal=project2d(md,md.nodeonmacayeal,1);
md.nodeonpattyn=project2d(md,md.nodeonpattyn,1);
md.nodeonstokes=project2d(md,md.nodeonstokes,1);

%boundary conditions
md.spcvx=project2d(md,md.spcvx,md.numlayers);
md.spcvy=project2d(md,md.spcvy,md.numlayers);
md.spcvz=project2d(md,md.spcvz,md.numlayers);
md.prognostic.spcthickness=project2d(md,md.prognostic.spcthickness,md.numlayers);
md.thermal.spctemperature=project2d(md,md.thermal.spctemperature,md.numlayers);

%Extrusion of Neumann BC
if ~isnan(md.pressureload),
	numberofneumann2d=size(md.pressureload,1)/md.numlayers;
	md.pressureload=[md.pressureload(1:numberofneumann2d,1:2) md.pressureload(1:numberofneumann2d,5:6)]; %Add two columns on the first layer 
end

%materials
md.materials.rheology_B=DepthAverage(md,md.materials.rheology_B);
md.materials.rheology_n=project2d(md,md.materials.rheology_n,1);

%special for thermal modeling:
md.basalforcings.melting_rate=project2d(md,md.basalforcings.melting_rate,1); 
md.basalforcings.geothermalflux=project2d(md,md.basalforcings.geothermalflux,1); %bedrock only gets geothermal flux

%update of connectivity matrix
md.connectivity=25;

%Collapse the mesh
nodes2d=md.numberofnodes2d;
elements2d=md.numberofelements2d;

%parameters
md.surface=project2d(md,md.surface,1);
md.thickness=project2d(md,md.thickness,1);
md.bed=project2d(md,md.bed,1);
md.nodeonboundary=project2d(md,md.nodeonboundary,1);
md.mask.elementonfloatingice=project2d(md,md.mask.elementonfloatingice,1);
md.mask.vertexonfloatingice=project2d(md,md.mask.vertexonfloatingice,1);
md.mask.elementongroundedice=project2d(md,md.mask.elementongroundedice,1);
md.mask.vertexongroundedice=project2d(md,md.mask.vertexongroundedice,1);

%Initialize with the 2d mesh
md.x=md.x2d;
md.y=md.y2d;
md.z=zeros(size(md.x2d));
md.numberofnodes=md.numberofnodes2d;
md.numberofelements=md.numberofelements2d;
md.elements=md.elements2d;

%Keep a trace of lower and upper nodes
md.lowernodes=NaN;
md.uppernodes=NaN;

%Remove old mesh 
md.x2d=NaN;
md.y2d=NaN;
md.elements2d=NaN;
md.numberofelements2d=md.numberofelements;
md.numberofnodes2d=md.numberofnodes;
md.numlayers=0;

%Update mesh type
md.dim=2;
