md=mesh(model,'../Exp/Square.exp',180000);
md=setmask(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.par');
md=extrude(md,3,1);
md=setelementstype(md,'pattyn','all');
md.cluster=none;
md=solve(md,DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	PatchToVec(md.results.DiagnosticSolution.Vx),...
	PatchToVec(md.results.DiagnosticSolution.Vy),...
	PatchToVec(md.results.DiagnosticSolution.Vz),...
	PatchToVec(md.results.DiagnosticSolution.Vel),...
	PatchToVec(md.results.DiagnosticSolution.Pressure),...
	};
