/*! \file CreateLoadsMelting.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateLoadsMelting(Loads** ploads, IoModel* iomodel){

	/*Intermediary*/
	int i;
	int    dim;
	int    numberofvertices;

	/*DataSet*/
	Loads*    loads    = NULL;

	/*Fetch parameters: */
	iomodel->Constant(&dim,DimEnum);
	iomodel->Constant(&numberofvertices,NumberOfVerticesEnum);

	/*if 2d: Error*/
	if (dim==2) _error_("2d meshes not supported yet");

	/*Recover pointer: */
	loads=*ploads;

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads(LoadsEnum);

	//create penalties for nodes: no node can have a temperature over the melting point
	iomodel->FetchData(2,NodeonbedEnum,ElementsEnum);
	CreateSingleNodeToElementConnectivity(iomodel);

	for (i=0;i<numberofvertices;i++){
		if((iomodel->my_vertices[i]==1)){
			if (iomodel->Data(NodeonbedEnum)[i]){ 
				loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,MeltingAnalysisEnum));
			}
		}
	}
	iomodel->DeleteData(2,NodeonbedEnum,ElementsEnum);

	/*Assign output pointer: */
	*ploads=loads;
}
