md=mesh(model,'../Exp/79North.exp',10000);
md=meshconvert(md);
md=setmask(md,'../Exp/79NorthShelf.exp','');
md=parameterize(md,'../Par/79North.par');
md=setelementstype(md,'macayeal','all');

%control parameters
md.nsteps=2;
md.prognostic_DG=1;
md.control_analysis=1;
md.control_type={'Dhdt'};
md.thickness_obs=md.thickness;
md.cm_min=-50*ones(md.numberofnodes,1);
md.cm_max=50*ones(md.numberofnodes,1);
md.cm_responses=201*ones(md.nsteps,1);
md.weights=ones(md.numberofnodes,1);
md.optscal=10/md.constants.yts*ones(md.nsteps,1);
md.maxiter=4*ones(md.nsteps,1);
md.cm_jump=0.99*ones(md.nsteps,1);

md.cluster=none;
md=solve(md,BalancethicknessSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Gradient' 'Misfits' 'Dhdt' 'Thickness'};
field_tolerances={1e-12,1e-12,1e-12,1e-12,1e-12,1e-12};
field_values={...
	PatchToVec(md.results.BalancethicknessSolution.Gradient1),...
	md.results.BalancethicknessSolution.J,...
	PatchToVec(md.results.BalancethicknessSolution.Dhdt),...
	PatchToVec(md.results.BalancethicknessSolution.Thickness)
};
