md=mesh(model,'../Exp/Pig.exp',30000);
md=setmask(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
md=extrude(md,4,1.1);
md=setelementstype(md,'macayeal','all');
md.cluster=none;
md.timestepping.time_step=0;
md=solve(md,SteadystateSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure','Temperature','BasalforcingsMeltingRate'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13
};
field_values={...
	PatchToVec(md.results.SteadystateSolution.Vx),...
	PatchToVec(md.results.SteadystateSolution.Vy),...
	PatchToVec(md.results.SteadystateSolution.Vz),...
	PatchToVec(md.results.SteadystateSolution.Vel),...
	PatchToVec(md.results.SteadystateSolution.Pressure),...
	PatchToVec(md.results.SteadystateSolution.Temperature),...
	PatchToVec(md.results.SteadystateSolution.BasalforcingsMeltingRate),...
	};
