/*
 * CreateNodesMelting.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../include/include.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesMelting(Nodes** pnodes, IoModel* iomodel){

	/*Intermediary*/
	int i;
	bool continuous_galerkin=true;
	int    numberofvertices;

	/*DataSets: */
	Nodes*    nodes = NULL;
	
	/*Fetch parameters: */
	iomodel->Constant(&numberofvertices,NumberOfVerticesEnum);

	/*Recover pointer: */
	nodes=*pnodes;

	/*Create nodes if they do not exist yet*/
	if(!nodes) nodes = new Nodes(NodesEnum);

	/*Continuous Galerkin partition of nodes: */
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements,iomodel->my_vertices,iomodel,continuous_galerkin);

	/*First fetch data: */
	iomodel->FetchData(6,NodeonbedEnum,NodeonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,VerticesTypeEnum,MaskVertexonwaterEnum);
	for (i=0;i<numberofvertices;i++){

		if(iomodel->my_vertices[i]){
			
			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,MeltingAnalysisEnum));

		}
	}
	iomodel->DeleteData(6,NodeonbedEnum,NodeonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,VerticesTypeEnum,MaskVertexonwaterEnum);

	/*Assign output pointer: */
	*pnodes=nodes;
}
