md=mesh(model,'../Exp/Pig.exp',10000);
md=setmask(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');

%impose hydrostatic equilibrium (required by Stokes)
md.bed=-md.materials.rho_ice/md.materials.rho_water*md.thickness;
md.surface=md.bed+md.thickness;
md=extrude(md,3,1);
md=setelementstype(md,'stokes','all');
md=modelextract(md,md.mask.elementonfloatingice);

%control parameters
md.control_analysis=1;
md.control_type={'MaterialsRheologyBbar'};
md.cm_min=10^6*ones(md.numberofnodes,1);
md.cm_max=2*10^9*ones(md.numberofnodes,1);
md.nsteps=2;
md.cm_responses=101*ones(md.nsteps,1);
md.weights=ones(md.numberofnodes,1);
md.optscal=10^8*ones(md.nsteps,1);
md.maxiter=2*ones(md.nsteps,1);
md.cm_jump=0.99*ones(md.nsteps,1);
md.vx_obs=md.vx; md.vy_obs=md.vy;

md.cluster=none;
md=solve(md,DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Gradient' 'Misfits' 'MaterialsRheologyB' 'Pressure' 'Vel' 'Vx' 'Vy'};
field_tolerances={1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10};
field_values={...
	PatchToVec(md.results.DiagnosticSolution.Gradient1),...
	md.results.DiagnosticSolution.J,...
	PatchToVec(md.results.DiagnosticSolution.MaterialsRheologyB),...
	PatchToVec(md.results.DiagnosticSolution.Pressure),...
	PatchToVec(md.results.DiagnosticSolution.Vel),...
	PatchToVec(md.results.DiagnosticSolution.Vx),...
	PatchToVec(md.results.DiagnosticSolution.Vy)
};
