md=mesh(model,'DomainOutline.exp',1000);
md=setmask(md,'','');
md=parameterize(md,'Bump.par');
md=setelementstype(md,'macayeal','all');
md.cluster=astrid;
md.cluster.np=13;
md=solve(md,DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vel','Pressure'};
field_tolerances={1e-13,1e-13,1e-13,1e-13};
field_values={...
	PatchToVec(md.results.DiagnosticSolution.Vx),...
	PatchToVec(md.results.DiagnosticSolution.Vy),...
	PatchToVec(md.results.DiagnosticSolution.Vel),...
	PatchToVec(md.results.DiagnosticSolution.Pressure),...
	};
