md=squaremesh(model,1000000,1000000,5,5);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setelementstype(md,'macayeal','all');
md.cluster=none;

%redo the parameter file for this special shelf. 
%constant thickness, constrained (vy=0) flow into an icefront, 
%from 0 m/yr at the grounding line.

%needed later
ymin=min(md.y);
ymax=max(md.y);
xmin=min(md.x);
xmax=max(md.x);

di=md.materials.rho_ice/md.materials.rho_water;

h=1000;
md.thickness=h*ones(md.numberofnodes,1);
md.bed=-md.materials.rho_ice/md.materials.rho_water*md.thickness;
md.surface=md.bed+md.thickness;

%Initial velocity and pressure
md.vx=zeros(md.numberofnodes,1);
md.vy=zeros(md.numberofnodes,1);
md.vz=zeros(md.numberofnodes,1);
md.pressure=zeros(md.numberofnodes,1);

%Materials
md.temperature=(273-20)*ones(md.numberofnodes,1);
md.materials.rheology_B=paterson(md.temperature);
md.materials.rheology_n=3*ones(md.numberofelements,1);

%Boundary conditions:
md.spcvx=NaN*ones(md.numberofnodes,1);
md.spcvy=NaN*ones(md.numberofnodes,1);
md.spcvz=NaN*ones(md.numberofnodes,1);

%constrain flanks to 0 normal velocity
pos=find(md.x==xmin | md.x==xmax);
md.spcvx(pos)=0;
md.spcvz(pos)=NaN;

%constrain grounding line to 0 velocity
pos=find(md.y==ymin);
md.spcvx(pos)=0;
md.spcvy(pos)=0;

%icefront
nodeonicefront=zeros(md.numberofnodes,1);
pos=find(md.y==ymax); nodeonicefront(pos)=1;
pos=find(nodeonicefront(md.segments(:,1)) | nodeonicefront(md.segments(:,2))); pressureload=md.segments(pos,:);
pressureload=[pressureload 1*md.elementoniceshelf(pressureload(:,end))];
md.pressureload=pressureload;

%partitioning
md.npart=md.numberofnodes;
md=partitioner(md,'package','linear','npart',md.npart);
md.part=md.part-1;

%Dakota options
%variables
md.variables.rheology_B=normal_uncertain('scaled_RheologyB',1,.5);

%responses
md.responses.MaxVel=response_function('MaxVel',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);

%method
md.qmu_method     =dakota_method('nond_l');

%parameters
md.qmu_params.direct=true;
md.qmu_params.analysis_driver='diagnostic';
md.qmu_params.evaluation_concurrency=1;
md.qmu_params.interval_type='forward';

%imperative! 
md.eps_rel=10^-10; %tighten for qmu analysese
md.dakota_analysis=1;

%solve
md=solve(md,DiagnosticSolutionEnum,'overwrite','y');

%Fields and tolerances to track changes
md=tres(md,'dakota');
md.results.dakota.importancefactors=importancefactors(md,'scaled_RheologyB','MaxVel')';
field_names     ={'importancefactors'};
field_tolerances={1e-10};
field_values={...
         md.results.dakota.importancefactors,...
	};
