%EISMINT benchmark experiment A
numlayers=10;
resolution=40000;

%To begin with the numerical model
md=mesh(model,'../Exp/SquareEISMINT750000.exp',resolution);
md=geography(md,'','');
md=parameterize(md,'../Par/RoundSheetEISMINT.par');

%We extrude the model to have a 3d model
md=extrude(md,numlayers,1);
md=setelementstype(md,'hutter','all');

%Spc the nodes on the bed
pos=find(md.nodeonbed);
md.spcvx(pos)=0;
md.spcvy(pos)=0;
md.spcvz(pos)=0;

%Adapt the time steps to the resolution
md.timestepping.time_step=20;
md.output_frequency=20;
md.timestepping.final_time=50000;
md.artificial_diffusivity=2;
md.thermal.stabilization=2;

%Now we can solve the problem 
md.cluster=generic('name',oshostname(),'np',8);
md=solve(md,TransientSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure','Thickness','Bed','Surface','Temperature','BasalforcingsMeltingRate'};
field_tolerances={1e-08,1e-08,1e-07,1e-08,1e-08,1e-08,1e-08,1e-08,1e-07,1e-07};
field_values={...
	PatchToVec(md.results.TransientSolution(end).Vx),...
	PatchToVec(md.results.TransientSolution(end).Vy),...
	PatchToVec(md.results.TransientSolution(end).Vz),...
	PatchToVec(md.results.TransientSolution(end).Vel),...
	PatchToVec(md.results.TransientSolution(end).Pressure),...
	PatchToVec(md.results.TransientSolution(end).Thickness),...
	PatchToVec(md.results.TransientSolution(end).Bed),...
	PatchToVec(md.results.TransientSolution(end).Surface),...
	PatchToVec(md.results.TransientSolution(end).Temperature),...
	PatchToVec(md.results.TransientSolution(end).BasalforcingsMeltingRate),...
	};
