%CONSTANTS class definition
%
%   Usage:
%      groundingline=groundingline();

classdef groundingline
	properties (SetAccess=public) 
		migration    = modelfield('default','','marshall',true,'preprocess','StringToEnum','format','Integer');
		melting_rate = modelfield('default',NaN,'marshall',true,'format','Double');
	end
	methods
		function obj = groundingline(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

			%Type of migration
			obj.migration='None';

			%basal melting rate correction: 
			obj.melting_rate=0; 


		end % }}}
	end
end
