radius=1e6;
shelfextent=2e5;
resolution=.5e5;
%mesh {{{1
md=roundmesh(model,radius,resolution);
%fix center node to 0,0
rad=sqrt((md.x).*md.x+(md.y).*md.y);
pos=find(rad==min(rad));
md.x(pos)=0; md.y(pos)=0; %the closest node to the center is changed to be exactly at the center
%}}}
%put our grounding line 'shelfextent' meters from the icefront {{{1
xelem=md.x(md.elements)*[1;1;1]/3;
yelem=md.y(md.elements)*[1;1;1]/3;
rad=sqrt((xelem).*xelem+(yelem).*yelem);
flags=zeros(md.numberofelements,1);
pos=find(rad>=(radius-shelfextent));
flags(pos)=1;
flags2=zeros(md.numberofelements,1);
md=geography(md,flags,flags2); 
%}}}
md=parameterize(md,'../Par/RoundSheetShelf.par');
md=setelementstype(md,'macayeal','all');
md.cluster=generic('name',oshostname(),'np',3);
%plug holes into the ice sheet, to test for grounding line migration. {{{1
di=md.rho_ice/md.rho_water;
rad=sqrt((md.x).*md.x+(md.y).*md.y);
pos=find(rad<200000);
md.thickness(pos)=100;
md.bed(pos)=-di*md.thickness(pos)-20;
md.surface(pos)=md.bed(pos)+md.thickness(pos);

pos=find(md.x<.2*1e6 & md.x>-.2*1e6 & md.y>0);
md.thickness(pos)=100;
md.bed(pos)=-di*md.thickness(pos)-20;
md.surface(pos)=md.bed(pos)+md.thickness(pos);

pos=find(md.x<.1*1e6 & md.x>-.1*1e6 & md.y<-.5*1e6 & md.y>-.6*1e6);
md.thickness(pos)=100;
md.bed(pos)=-di*md.thickness(pos)-20;
md.surface(pos)=md.bed(pos)+md.thickness(pos);
%}}}

%test different grounding line dynamics.
%grounding line: 
md.groundingline.migration='AgressiveMigration';
md=solve(md,GroundinglineMigration2DSolutionEnum);
element_on_iceshelf_agressive=PatchToVec(md.results.GroundinglineMigration2DSolution.ElementOnIceShelf);

md.groundingline.migration='SoftMigration';
md=solve(md,GroundinglineMigration2DSolutionEnum);
element_on_iceshelf_soft=PatchToVec(md.results.GroundinglineMigration2DSolution.ElementOnIceShelf);

%Fields and tolerances to track changes
field_names     ={'ElementOnIceShelfAgressive','ElementOnIceShelfSoft'};
field_tolerances={1e-13,1e-13};
field_values={element_on_iceshelf_agressive,element_on_iceshelf_soft};
