md=mesh(model,'../Exp/Pig.exp',30000);
md=geography(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
md=extrude(md,3,1);
md=setelementstype(md,'pattyn','all');
md.artificial_diffusivity=2;
md.timestepping.time_step=0;
md.min_thermal_constraints=40;
md=solve(md,ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature','BasalforcingsMeltingRate'};
field_tolerances={1e-13,1e-12};
field_values={...
	PatchToVec(md.results.ThermalSolution.Temperature),...
	PatchToVec(md.results.ThermalSolution.BasalforcingsMeltingRate),...
	};
