function md=flaim(md,options)
%QMU - apply Quantification of Margins and Uncertainties techniques 
%      to a solution sequence (like diagnostic.m, progonstic.m, etc ...), 
%      using the Dakota software from Sandia.
%
%   options come from the solve.m routine. They can include flaim options:
%
%       fmdir:  any directory where to run the flaim analysis
%       fmfile: input file for flaim
%       overwrite: overwrite qmudir before analysis
%       keep: keep qmudir after analysis

disp('preprocessing flaim inputs');

%first create temporary directory in which we will work
if strncmpi(options.overwrite,'y',1)
	system(['rm -rf ' options.fmdir '/*']); 
else
	%does the directory exist? if so, then error out
	if exist(options.fmdir)==7,
		error('Existing ''%s'' directory, cannot overwrite. Specify ''overwrite'',''y'' option in solve arguments.',options.fmdir);
	end
end
mkdir(options.fmdir)
system(['cp -p ' md.flaim.tracks ' ' options.fmdir]);
% for testing
%system(['cp -p issm-split-geikie1-targets.kml ' options.fmdir]);
%system(['cp -p solution_best.kml ' options.fmdir]);
%system(['cp -p flaim.targets.log ' options.fmdir]);
cd(options.fmdir)

%  process file names

[pathstr,name,ext,versn] = fileparts(md.flaim.tracks);
fm_tracks=fullfile('',[name ext versn]);
[pathstr,name,ext,versn] = fileparts(options.fmfile);
if isempty(ext)
    ext='.kml';
end
filekml=fullfile(pathstr,[name ext versn]);
ext='.log';
filelog=fullfile(pathstr,[name ext versn]);
if ~isempty(md.flaim.solution)
	[pathstr,name,ext,versn] = fileparts(md.flaim.solution);
	filesol=fullfile('',[name '' '']);
else
	filesol='solution_best';
end

%  calculate latitude and longitude, if necessary 

if isempty(md.lat)  || ((numel(md.lat) == 1)  && isnan(md.lat)) || ...
   isempty(md.long) || ((numel(md.long) == 1) && isnan(md.long))
	if     ~isfield(options,'latsgn')
		error(['Missing ''latsgn'' parameter to calculate missing lat/long values.']);
	elseif (abs(options.latsgn) ~= 1)
		error(['Incorrect latsgn=' num2str(options.latsgn) ' parameter to calculate missing lat/long values.']);
	else
		display('Converting x/y values to lat/long values.');
		[md.lat,md.long]=xy2ll(md.x,md.y,options.latsgn);
	end
end

%  colormap command operates on a figure, so create an invisible one
%  (could also directly call colormaps, e.g. jet(64), but risky)

if ~isempty(md.flaim.criterion)
	hfig=figure('Visible','off');
	if isfield(options,'cmap') && ~isempty(options.cmap)
		colormap(options.cmap)
	end
	options.cmap=colormap;
	close(hfig)
end
if ~isfield(options,'cmap')
	options.cmap=[];
end

%  write the target kml file

display('Calling KMLMeshWrite.');
KMLMeshWrite(md.miscellaneous.name,md.miscellaneous.notes,md.elements,md.nodeconnectivity,md.lat,md.long,md.part,md.flaim.criterion,options.cmap,filekml);
%  for testing
%filekml='issm-split-geikie1-targets.kml';

%  call flaim

display('Calling flaim.');
FLAIM_DIR=flaimdir();
%system([FLAIM_DIR '/clasp/swathModule/models/issm/issm.exe -kml ' fm_tracks ' -kml ' filekml ' -gridsatequator 200000 -opt 1 -hst 2017-276T02:57:00 -hdur 4d -sparsepoints -usevalueordering -split-antimeridian >& ' filelog]);
flaim_cmd=[FLAIM_DIR '/clasp/swathModule/models/issm/issm.exe -kml ' fm_tracks ' -kml ' filekml ' -gridsatequator ' int2str(md.flaim.gridsatequator) ' -opt 1 -hst 2017-276T02:57:00 -hdur 4d -sparsepoints'];
if (md.flaim.usevalueordering)
	flaim_cmd=[flaim_cmd ' -usevalueordering'];
end
if (md.flaim.split_antimeridian)
	flaim_cmd=[flaim_cmd ' -split-antimeridian'];
end
flaim_cmd=[flaim_cmd ' >& ' filelog];
system(flaim_cmd);

%  post-process the flaim output

display(['Post-processing the flaim output in the ''' options.fmdir ''' sub-directory.']);
if exist('solution_best.kml','file')
	if ~strcmp(filesol,'solution_best')
		system(['mv solution_best.kml ' filesol '.kml']);
	end
	if ~strncmpi(options.keep,'y',1)
		md.results.FlaimSolution.solution=[filesol];
	else
		md.results.FlaimSolution.solution=[options.fmdir '/' filesol];
	end
else
	md.results.FlaimSolution.solution='';
end
if exist(filelog,'file')
	[status,fline]=system(['grep -i quality ' filelog]);
	if ~isempty(fline)
		strings=textscan(fline,'%s','delimiter',' =,','MultipleDelimsAsOne',1);
		md.results.FlaimSolution.quality =sscanf(strings{1}{2},'%f');
	else
		warning('Could not find ''quality'' in the ''%s/%s'' flaim log file.',options.fmdir,filelog);
		md.results.FlaimSolution.quality =NaN;
	end
	fidi=fopen(filelog,'r');
	while true
		fline=fgetl(fidi);
		if ~ischar(fline) || strncmp(fline,'........',8)
			break
		end
	end
	fido=fopen([filesol '.log'],'w');
	while true
		fline=fgetl(fidi);
		if ~ischar(fline)
			break
		end
		fprintf(fido,'%s\n',fline);
	end
	fclose(fidi);
	fclose(fido);
end
display(md.results.FlaimSolution);

cd ..
if ~strncmpi(options.keep,'y',1)
	system(['mv ' options.fmdir '/' filesol '.kml .']);
	system(['mv ' options.fmdir '/' filesol '.log .']);
	system(['rm -rf ' options.fmdir]);
end

