%SETTINGS class definition
%
%   Usage:
%      settings=settings();

classdef settings
	properties (SetAccess=public) 
		io_gather = modelfield('default',0,'marshall',true,'format','Boolean');
		lowmem    = modelfield('default',0,'marshall',true,'format','Boolean');
	end
	methods
		function obj = settings(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

			%lowmem??
			obj.lowmem=0;

			%i/o:
			obj.io_gather=1;
		end % }}}
	end
end
