/*!\file:  SpawnCoreSerial.cpp
 * \brief: run core ISSM solution using Dakota inputs. Call the Serial core solution, using mexCallMATLAB
 * \sa SpawnCore.cpp SpawnCoreParallel.cpp
 *
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#undef __FUNCT__ 
#define __FUNCT__ "SpawnCoreSerial"

#include "../objects/objects.h"
#include "../io/io.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "./Qmux.h"
#include "../include/macros.h"

void SpawnCoreSerial(double* responses, int numresponses, double* variables, char** variables_descriptors,int numvariables, mxArray* femmodels,mxArray* inputs,int analysis_type,int sub_analysis_type,int counter){

	int i;
	
	//inputs to matlab routine
	mxArray* mxvariables=NULL;
	double*  variables_copy=NULL;
	mxArray* mxvariabledescriptors=NULL;
	mxArray* mxanalysis_type=NULL;
	mxArray* mxsub_analysis_type=NULL;
	mxArray* mxcounter=NULL;
	mwSize   dims[2]={0};

	//mexCallMATLAB arrays
	mxArray* array[7];

	//output from SpawnCore in matlab routine.
	mxArray* mxresponses=NULL;

	/*Create variables and variable descriptors mxArrays that we will feed to the core solution for update of the inputs: */
	mxvariables=mxCreateDoubleMatrix(numvariables,1,mxREAL);
	variables_copy=(double*)xmalloc(numvariables*sizeof(double));
	memcpy(variables_copy,variables,numvariables*sizeof(double));
	mxSetPr(mxvariables,variables_copy);

	dims[0]=numvariables;
	dims[1]=1;
	mxvariabledescriptors=mxCreateCellArray(2,dims);
	for(i=0;i<numvariables;i++){
		mxSetCell(mxvariabledescriptors,i,mxCreateString(variables_descriptors[i]));
	}

	mxanalysis_type=mxCreateDoubleScalar((double)analysis_type);
	mxsub_analysis_type=mxCreateDoubleScalar((double)sub_analysis_type);
	mxcounter=mxCreateDoubleScalar((double)counter);

	//call SpwanCore matlab routine.
	array[0]=femmodels;
	array[1]=inputs;
	array[2]=mxvariables;
	array[3]=mxvariabledescriptors;
	array[4]=mxanalysis_type;
	array[5]=mxsub_analysis_type;
	array[6]=mxcounter;

	mexCallMATLAB(1,&mxresponses,7,array,"SpawnCore");

	/*copy responses back to dakota: */
	memcpy(responses,mxGetPr(mxresponses),numresponses*sizeof(double));

	//destroy constructed arrays: 
	mxDestroyArray(mxvariables);
	mxDestroyArray(mxvariabledescriptors);
	mxDestroyArray(mxresponses);
	mxDestroyArray(mxanalysis_type);
	mxDestroyArray(mxsub_analysis_type);
	mxDestroyArray(mxcounter);

}

