function outoptions=process_solve_options(options)
%DEFAULT_SOLVE_OPTIONS - set up default options for solve phase
%
%   Usage:
%      options=process_solve_options(options)
%
%   See also: SOLVE,RECOVER_SOLVE_OPTIONS

%analysis_type: check on this option, error out otherwise
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'analysis_type'),
		analysis_type=options{i,2};
		found=1;
	end
end
if ~found,
	error('recover_solve_options error message: no ''analysis_type'' was provided');
end

%package: is there one? check to ''cielo''
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'package'),
		package=options{i,2};
		found=1;
	end
end
if ~found,
	disp('recover_solve_options info message: no ''package'' was provided, defaulting to ''cielo''');
	options(end+1,:)={'package' 'cielo'};
	package='cielo';
end

if ~ischar(package), 
	error(['process_solve_options error message: package ' package ' not supported yet']);
end

%sub_analysis_type: check on it, not mandatory
found=0;
for i=1:size(options,1),
	if strcmpi(options{i,1},'sub_analysis_type'),
		sub_analysis_type=options{i,2};
		found=1;
	end
end
if ~found
	if ~strcmpi(analysis_type,'thermal'),
		sub_analysis_type='none';
	else
		disp('recover_solve_options info message: no ''sub_analysis_type'' was provided, defaulting to ''steady''');
		sub_analysis_type='steady';
	end
end

%check solution type is supported
if ~(strcmpi(analysis_type,'control') |  ...
		strcmpi(analysis_type,'diagnostic') |  ...
		strcmpi(analysis_type,'prognostic') |  ...
		strcmpi(analysis_type,'thermal') |  ...
		strcmpi(analysis_type,'parameters') |  ...
		strcmpi(analysis_type,'mesh') |  ...
		strcmpi(analysis_type,'mesh2grid') |  ...
		strcmpi(analysis_type,'transient') ),
	error(['process_solve_options error message: analysis_type ' analysis_type ' not supported yet!']);
end
if ~(strcmpi(sub_analysis_type,'none') |  ...
		strcmpi(sub_analysis_type,'steady') |  ...
		strcmpi(sub_analysis_type,'horiz') |  ...
		strcmpi(sub_analysis_type,'vert') |  ...
		strcmpi(sub_analysis_type,'') |  ...
		strcmpi(sub_analysis_type,'transient') ),
	error(['process_solve_options error message: sub_analysis_type ' sub_analysis_type ' not supported yet!']);
end
if ~(strcmpi(package,'cielo') |  ...
		strcmpi(package,'ice') |  ...
		strcmpi(package,'macayeal') ),
	error(['process_solve_options error message: package ' package ' not supported yet!']);
end


%  process qmu arguments

%first, the defaults
qmudir ='qmu';% qmudir =['qmu_' datestr(now,'yyyymmdd_HHMMSS')];
qmufile='qmu';%  qmufile can not be changed unless cielo_ice_script.sh is also changed
ivar   =1;
iresp  =1;
imethod=1;
iparams=1;
runmpi =false;

for i=1:size(options,1),
	switch options{i,1},
	case 'qmudir'
		qmudir=options{i,2};
	case 'qmufile'
		qmufile=options{i,2};
	case 'ivar'
		ivar=options{i,2};
	case 'iresp'
		iresp=options{i,2};
	case 'imethod'
		imethod=options{i,2};
	case 'iparams'
		iparams=options{i,2};
	case 'overwrite'
		outoptions.overwrite=options{i,2};
	case 'outfiles'
		outoptions.outfiles=options{i,2};
	case 'rstfile'
		outoptions.rstfile=options{i,2}; 
	case 'rundakota'
		outoptions.rundakota=options{i,2};
	case 'runmpi'
		runmpi=options{i,2};
	otherwise
		%nothing
	end
end

%setup final options structure
outoptions.analysis_type=analysis_type;
outoptions.package=package;
outoptions.sub_analysis_type=sub_analysis_type;
outoptions.qmudir=qmudir;
outoptions.qmufile=qmufile;
outoptions.ivar=ivar;
outoptions.iresp=iresp;
outoptions.imethod=imethod;
outoptions.iparams=iparams;
outoptions.runmpi=runmpi;
