%  set up some qmu studies, like might be done in Pig.par

%%  a variety of variables

%  seems to be a Matlab bug here (on Linux, not WinXP) -- unless
%  the class has been called, "empty" method can not be found
normal_uncertain;
continuous_design;
continuous_state;
linear_inequality_constraint;
linear_equality_constraint;
response_function;
objective_function;
least_squares_term;
nonlinear_inequality_constraint;
nonlinear_equality_constraint;

md.variables=struct();
md.variables.nuv=normal_uncertain.empty();
md.variables.nuv(end+1)=normal_uncertain('rho_ice',917,45.85);
md.variables.nuv(end+1)=normal_uncertain('thickness',1,0.05);
md.variables.nuv(end+1)=normal_uncertain('drag',1,0.05);
md.variables.cdv=continuous_design.empty();
md.variables.cdv(end+1)=continuous_design('thickness',1,0.9,1.1);
md.variables.cdv(end+1)=continuous_design('drag',1,0.5,1.5);
md.variables.csv=continuous_state.empty();
md.variables.csv(end+1)=continuous_state('gravity',9.8);
md.variables.lic=linear_inequality_constraint.empty();
md.variables.lic(end+1)=linear_inequality_constraint([1 2 3],4,5);
md.variables.lic(end+1)=linear_inequality_constraint([1 2],4,5);
md.variables.lic(end+1)=linear_inequality_constraint([1 2 3 4],4,5);
md.variables.lec=linear_equality_constraint.empty();
md.variables.lec(end+1)=linear_equality_constraint([1 2 3],4);

%%  a variety of responses

md.responses=struct();
md.responses.rf =response_function.empty();
md.responses.rf (end+1)=response_function('max_abs_vx',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);
md.responses.rf (end+1)=response_function('max_abs_vy',[100 200 300],[]);
md.responses.rf (end+1)=response_function('max_vel'   ,[100 200 300],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);
md.responses.of =objective_function.empty();
md.responses.of (end+1)=objective_function('max_vel');
md.responses.lst=least_squares_term.empty();
md.responses.lst(end+1)=least_squares_term('max_vel');
md.responses.nic=nonlinear_inequality_constraint.empty();
md.responses.nic(end+1)=nonlinear_inequality_constraint('max_abs_vx',0,1000);
md.responses.nic(end+1)=nonlinear_inequality_constraint('max_abs_vy',0,1000);
md.responses.nec=nonlinear_equality_constraint.empty();
md.responses.nec(end+1)=nonlinear_equality_constraint('max_abs_vx',500);
md.responses.nec(end+1)=nonlinear_equality_constraint('max_abs_vy',500);

%%  a variety of studies

%  a sampling study

md.qmu_method       =dakota_method('nond_samp');
md.qmu_method(end)=dmeth_params_set(md.qmu_method(end),...
    'seed',1234,...
    'samples',10);

%  a local reliability study

md.qmu_method(end+1)=dakota_method('nond_l');

%  a multidimensional parameter study

md.qmu_method(end+1)=dakota_method('multi');
md.qmu_method(end)=dmeth_params_set(md.qmu_method(end),...
    'partitions',2);

%  an optimization study

md.qmu_method(end+1)=dakota_method('conmin_f');
md.qmu_method(end)=dmeth_params_set(md.qmu_method(end),...
    'max_iterations',10,...
    'max_function_evaluations',50,...
    'convergence_tolerance',0.001);

%%  a variety of parameters

md.qmu_params.evaluation_concurrency=4;
md.qmu_params.analysis_driver='';
md.qmu_params.analysis_components='';
md.qmu_params.interval_type='forward';
md.qmu_params.fd_gradient_step_size=0.001;

md.npart=10;
md.rifts.numrifts=5;

md.qmu
