%HYDROLOGY class definition
%
%   Usage:
%      hydrology=hydrology();

classdef hydrology
	properties (SetAccess=public) 
		spcwatercolumn = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		n              = modelfield('default',0,'marshall',true,'format','Double'); 
		CR             = modelfield('default',0,'marshall',true,'format','Double');
		p              = modelfield('default',0,'marshall',true,'format','Double');
		q              = modelfield('default',0,'marshall',true,'format','Double');
		kn             = modelfield('default',0,'marshall',true,'format','Double');
	end
	methods
		function obj = hydrology(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

			%Parameters from Johnson's 2002 thesis, section 3.5.4			 
			obj.n=.02;			 
			obj.CR=2;		 
			obj.p=2;		 
			obj.q=1;		 
			obj.kn=0;
		end % }}}
	end
end
