function femmodel=steadystate_core(femmodel);
%STEADYSTATE_CORE - compute the core temperature and velocity field  at thermal steady state.
%
%   Usage:
%      femmodel=steadystate_core(femmodel);
%

	%recover parameters common to all solutions
	dim=femmodel.parameters.Dim;
	control_analysis=femmodel.parameters.ControlAnalysis;
	solution_type=femmodel.parameters.SolutionType;

	%Initialize counter
	step=1;

	while true,

		issmprintf(VerboseSolution,'\n%s%i\n','   computing velocities and temperatures for step: ',step);
		femmodel=thermal_core(femmodel); 

		issmprintf(VerboseSolution,'\n%s',['   computing new velocity']);
		femmodel=diagnostic_core(femmodel); 

		if step>1,
			issmprintf(VerboseSolution,'\n%s',['   checking temperature, velocity and pressure convergence']);
			if steadystateconvergence(femmodel), break; end
		end 

		issmprintf(VerboseSolution,'\n%s',['   saving velocities, temperature and pressure for convergence']);
		femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VxEnum,VxPicardEnum);
		femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VyEnum,VyPicardEnum);
		femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VzEnum,VzPicardEnum);
		femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,PressureEnum,PressurePicardEnum);
		femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,TemperatureEnum,TemperatureOldEnum);

		%Increase counter
		step=step+1;
	end

	if (solution_type==SteadystateSolutionEnum & ~control_analysis),
		issmprintf(VerboseSolution,'\n%s',['   saving results']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VxEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VyEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VzEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VelEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,PressureEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,TemperatureEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,BasalforcingsMeltingRateEnum);
	end

end %end of function
