/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

#include "../modules/EnumToStringx/EnumToStringx.h"
#include "../modules/StringToEnumx/StringToEnumx.h"

enum definitions{
	/*model fields {{{1*/
	ConstantsGEnum,
	ConstantsReferencetemperatureEnum,
	ConstantsYtsEnum,
	SurfaceforcingsAccumulationRateEnum,
	SurfaceforcingsAblationRateEnum,
	SurfaceforcingsMassBalanceEnum,
	BasalforcingsMeltingRateEnum,
	BasalforcingsMeltingRateCorrectionEnum,
	BasalforcingsGeothermalfluxEnum,
	FrictionCoefficientEnum,
	FrictionPEnum,
	FrictionQEnum,
	/*}}}*/
	/*Datasets {{{1*/
	ConstraintsEnum,
	ElementsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ParametersEnum,
	VerticesEnum,
	ResultsEnum,
	/*}}}*/
	/*Solution types {{{1 */
	SolutionTypeEnum,
	/*}}}*/
	/*Analysis types {{{1 */
	AnalysisTypeEnum,
	ConfigurationTypeEnum,
	AnalysisCounterEnum,
	//diagnostic
	DiagnosticSolutionEnum,
	DiagnosticHorizAnalysisEnum,
	DiagnosticVertAnalysisEnum,
	DiagnosticHutterAnalysisEnum,
	//control
	AdjointSolutionEnum,
	AdjointHorizAnalysisEnum,
	AdjointBalancethicknessAnalysisEnum,
	ControlAnalysisEnum,
	//thermal
	ThermalSolutionEnum,
	ThermalAnalysisEnum,
	//hydro
	HydrologySolutionEnum,
	HydrologyAnalysisEnum,
	//transient
	TransientSolutionEnum,
	GroundinglineMigration2DSolutionEnum,
	//slope
	BedSlopeSolutionEnum,
	BedSlopeAnalysisEnum,
	SurfaceSlopeSolutionEnum,
	SurfaceSlopeAnalysisEnum,
	BedSlopeXAnalysisEnum,
	BedSlopeYAnalysisEnum,
	SurfaceSlopeXAnalysisEnum,
	SurfaceSlopeYAnalysisEnum,
	//prognostic
	BalancethicknessSolutionEnum,
	BalancethicknessAnalysisEnum,
	PrognosticSolutionEnum,
	PrognosticAnalysisEnum,
	//melting
	MeltingAnalysisEnum,
	//steadystate
	SteadystateSolutionEnum,
	//flaim
	FlaimSolutionEnum,
	FlaimAnalysisEnum,
	//none
	NoneAnalysisEnum,
	/*}}}*/
	/*Approximations {{{1*/
	ApproximationEnum,
	HutterApproximationEnum,
	MacAyealApproximationEnum,
	MacAyealPattynApproximationEnum,
	MacAyealStokesApproximationEnum,
	NoneApproximationEnum,
	PattynApproximationEnum,
	PattynStokesApproximationEnum,
	StokesApproximationEnum,
	/*}}}*/
	/*Objects {{{1*/
	HookEnum,
	SegmentEnum,
	/*Elements: */
	ElementEnum,
	DofIndexingEnum,
	PentaEnum,
	TriaEnum,
	/*Nodes: */
	NodeEnum,
	VertexEnum,
	/*Loads: */
	IcefrontEnum,
	NumericalfluxEnum,
	PengridEnum,
	PenpairEnum,
	RiftfrontEnum,
	SegmentRiftfrontEnum,
	MacAyeal2dIceFrontEnum,
	MacAyeal3dIceFrontEnum,
	PattynIceFrontEnum,
	StokesIceFrontEnum,
	/*Materials: */
	MaticeEnum,
	MatparEnum,
	/*Inputs: */
	InputEnum,
	BoolInputEnum,
	DoubleInputEnum,
	IntInputEnum,
	PentaVertexInputEnum,
	TriaVertexInputEnum,
	ControlInputEnum,
	/*Params: */
	ParamEnum,
	BoolParamEnum,
	DoubleMatParamEnum,
	DoubleMatArrayParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	IntParamEnum,
	IntVecParamEnum,
	FileParamEnum,
	PetscMatParamEnum,
	PetscVecParamEnum,
	StringArrayParamEnum,
	StringParamEnum,
	/*Results: */
	ElementResultEnum,
	ExternalResultEnum,
	/*Spc: */
	SpcStaticEnum,
	SpcTransientEnum,
	/*}}}*/
	/*Geography {{{1*/
	IceSheetEnum,
	IceShelfEnum,
	/*}}}*/
	/*Fill {{{1*/
	WaterEnum,
	IceEnum,
	AirEnum,
	MelangeEnum,
	/*}}}*/
	/*Rift state {{{1*/
	FreeEnum,
	OpenEnum,
	ClosedEnum,
	/*}}}*/
	/*Inputs {{{1*/
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	AdjointpEnum,
	BedEnum,
	BathymetryEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BoundaryEnum,
	CmResponseEnum,
	CmResponsesEnum,
	ConstantEnum,
	ControlTypeEnum,
	ConvergedEnum,
	DtEnum,
	TimeAdaptEnum,
	CflCoefficientEnum,
	ElementOnBedEnum,
	ElementOnIceSheetEnum,
	ElementOnIceShelfEnum,
	ElementOnSurfaceEnum,
	ElementOnWaterEnum,
	FillEnum,
	FractionIncrementEnum,
	FrictionEnum,
	HydrostaticAdjustmentEnum,
	InternalEnum,
	IuToExtEnum,
	ExtToIuEnum,
	MassFluxEnum,
	ThicknessAbsMisfitEnum,
	SurfaceAbsVelMisfitEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceAverageVelMisfitEnum,
	MaxPenetrationEnum,
	MeltingOffsetEnum,
	GroundinglineMeltingRateEnum,
	MisfitEnum,
	NodeOnBedEnum,
	NodeOnIceSheetEnum,
	NodeOnIceShelfEnum,
	NodeOnSurfaceEnum,
	NumberNodeToElementConnectivityEnum,
	PenaltyOffsetEnum,
	PressureEnum,
	PressurePicardEnum,
	VelocityEnum,
	QmuPressureEnum,
	ResetPenaltiesEnum,
	RheologyBEnum,
	RheologyBbarEnum,
	RheologyNEnum,
	SegmentOnIceShelfEnum,
	ShelfDampeningEnum,
	StabilizeConstraintsEnum,
	SurfaceAreaEnum,
	SurfaceEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperaturePicardEnum,
	TemperatureOldEnum,
	ThicknessEnum,
	ThicknessCoeffEnum,
	ThicknessObsEnum,
	TypeEnum,
	VelEnum,
	VelObsEnum,
	ViscosityOvershootEnum,
	VxAverageEnum,
	VxEnum,
	VxObsEnum,
	VxPicardEnum,
	QmuVxEnum,
	VyAverageEnum,
	VyEnum,
	VyObsEnum,
	VyPicardEnum,
	QmuVyEnum,
	VzEnum,
	VzObsEnum,
	VzPicardEnum,
	VzMacAyealEnum,
	VzPattynEnum,
	VzStokesEnum,
	QmuVzEnum,
	WeightsEnum,
	/*}}}*/
	/*Element types{{{1*/
	P0Enum,
	P1Enum,
	P1DGEnum,
	/*}}}*/
	/*Results{{{1*/
	DoubleElementResultEnum,
	TriaVertexElementResultEnum,
	PentaVertexElementResultEnum,
	BoolElementResultEnum,
	BoolExternalResultEnum,
	DoubleExternalResultEnum,
	DoubleVecExternalResultEnum,
	DoubleMatExternalResultEnum,
	IntExternalResultEnum,
	PetscVecExternalResultEnum,
	StringExternalResultEnum,
	JEnum,
	PatchEnum,
	PatchVerticesEnum,
	PatchNodesEnum,
	TimeEnum,
	OutputFrequencyEnum,
	WaterColumnOldEnum,
	/*}}}*/
	/*Io{{{1*/
	IoGatherEnum,
	/*}}}*/
	/*Responses{{{1*/
	MinVelEnum,
	MaxVelEnum,
	MinVxEnum,
	MaxVxEnum,
	MaxAbsVxEnum,
	MinVyEnum,
	MaxVyEnum,
	MaxAbsVyEnum,
	MinVzEnum,
	MaxVzEnum,
	MaxAbsVzEnum,
	/*}}}*/
	/*Convergence{{{1*/
	RelativeEnum,
	AbsoluteEnum,
	IncrementalEnum,
	/*}}}*/
	/*Grounding Line{{{1*/
	NoneEnum,
	AgressiveMigrationEnum,
	SoftMigrationEnum,
	/*}}}*/
	/*Material{{{1*/
	RhoIceEnum,
	RhoWaterEnum,
	GravityEnum,
	MixedLayerCapacityEnum,
	ThermalExchangeVelocityEnum,
	/*}}}*/
	/*Solver{{{1*/
	StokesSolverEnum,
	/*}}}*/
	/*Parameters{{{1*/
	IntersectEnum,
	ColinearEnum,
	SeparateEnum,
	BetaEnum,
	CmGradientEnum,
	CmJumpEnum,
	CmMaxEnum,
	CmMinEnum,
	AdjointEnum,
	GradientEnum,
	Gradient1Enum,
	Gradient2Enum,
	Gradient3Enum,
	OldGradientEnum,
	ConnectivityEnum,
	ControlSteadyEnum,
	DimEnum,
	EpsAbsEnum,
	EpsCmEnum,
	EpsRelEnum,
	EpsResEnum,
	LowmemEnum,
	MaxNonlinearIterationsEnum,
	MinMechanicalConstraintsEnum,
	MinThermalConstraintsEnum,
	NdtEnum,
	NumriftsEnum,
	NumberOfElementsEnum,
	NumberOfVerticesEnum,
	OutputFilePointerEnum,
	DakotaAnalysisEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuMassFluxSegmentsEnum,
	QmuOutNameEnum,
	QmuPartEnum,
	QmuNumberOfResponsesEnum,
	IndexedEnum,
	RegularEnum,
	IndexEnum,
	ScaledEnum,
	NodalEnum,
	ResponsedescriptorsEnum,
	VariabledescriptorsEnum,
	VerboseEnum,
	PetscOptionsStringsEnum,
	PetscOptionsAnalysesEnum,
	GsetEnum,
	FsetEnum,
	SsetEnum,
	GroundinglineMigrationEnum,
	/*}}}*/
	/*Interpolation {{{1*/
	TriangleInterpEnum,
	BilinearInterpEnum,
	NearestInterpEnum,
	/*}}}*/
	/*Options{{{1*/
	OptionEnum,
	OptionCellEnum,
	OptionCharEnum,
	OptionStructEnum,
	OptionDoubleEnum,
	OptionLogicalEnum,
	/*}}}*/
	/*Rheology law (move too Material) {{{1*/
	RheologyLawEnum,
	PatersonEnum,
	ArrheniusEnum,
	/*}}}*/
	VxMeshEnum,
	VyMeshEnum,
	VzMeshEnum,
	EnthalpySolutionEnum,
	EnthalpyAnalysisEnum,
	EnthalpyEnum,
	EnthalpyPicardEnum,
	ThicknessAbsGradientEnum,
	DatasetInputEnum,
	StepResponsesEnum,
	IntMatParamEnum,
	RheologyBbarAbsGradientEnum,
	DragCoefficientAbsGradientEnum,
	TransientInputEnum,
	/*Temporary*/
	NumberOfElements2DEnum,
	NumControlTypeEnum,
	SpcvyEnum,
	HydroQEnum,
	NodeOnWaterEnum,
	YEnum,
	ElementsTypeEnum,
	PenaltiesEnum,
	PrognosticDGEnum,
	PressureloadEnum,
	HydroCREnum,
	NameEnum,
	VerticesTypeEnum,
	HydroKnEnum,
	SpcvzEnum,
	NumberOfNodes2DEnum,
	NodeOnStokesEnum,
	NodeOnHutterEnum,
	ZEnum,
	RiftsEnum,
	SpcthicknessEnum,
	SpctemperatureEnum,
	PenaltyLockEnum,
	SpcvxEnum,
	UpperelementsEnum,
	HydroPEnum,
	NodeOnPattynEnum,
	EdgesEnum,
	Elements2DEnum,
	XEnum,
	NumCmResponsesEnum,
	NodeOnMacayealEnum,
	ElementconnectivityEnum,
	SpcwatercolumnEnum,
	ArtificialDiffusivityEnum,
	HydroNEnum,
	NumlayersEnum,
	DiagnosticRefEnum,
	IshutterEnum,
	IsmacayealpattynEnum,
	IsstokesEnum,
	StokesreconditioningEnum,
	LowerelementsEnum,
	HeatcapacityEnum,
	LatentheatEnum,
	ThermalconductivityEnum,
	MeltingpointEnum,
	DhdtEnum,
	IsprognosticEnum,
	IsdiagnosticEnum,
	IsthermalEnum,
	NstepsEnum,
	MaxiterEnum,
	TolxEnum,
	OptscalEnum,
	OutputfilenameEnum,
	WaterfractionEnum,
	WatercolumnEnum,
	WaitonlockEnum,
	NumberOfResponsesEnum,
	NpartEnum,
	PartEnum,
	MaxSteadystateIterationsEnum,
	RequestedOutputsEnum,
	NumRequestedOutputsEnum,
	BasalFrictionEnum,
	ViscousHeatingEnum,
	QmuTemperatureEnum,
	HydrologyWaterVxEnum,
	HydrologyWaterVyEnum,
	SpcDynamicEnum,
	NumberOfEdgesEnum,
	ResultsOnVerticesEnum,
	/*Automatic Differentiation {{{1*/
	AdAnalysisEnum, 
	AdForwardEnum,
	AdReverseEnum,
	/*}}}*/
	MaximumNumberOfEnums
};

/*Functions on enums: */
char *EnumToModelField(int  en);

#endif
