md=mesh(model,'../Exp/Square.exp',150000);
md=geography(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md=extrude(md,4,1);
md=setelementstype(md,'pattyn','all');
md.cluster=generic('name',oshostname(),'np',3);
md.dt=0;
md=solve(md,ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature','BasalforcingsMeltingRate'};
field_tolerances={1e-13,1e-13};
field_values={...
	PatchToVec(md.results.ThermalSolution.Temperature),...
	PatchToVec(md.results.ThermalSolution.BasalforcingsMeltingRate),...
	};
