/*
 * UpdateElementsAndMaterialsControl:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../modules/modules.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsAndMaterialsControl(Elements* elements,Materials* materials, IoModel* iomodel){

	/*Intermediary*/
	int       i;
	int       counter;
	Element  *element = NULL;
	Material *material = NULL;
	int    numberofelements;
	int    num_control_type;
	bool   control_analysis;

	
	/*Fetch parameters: */
	iomodel->Constant(&numberofelements,NumberOfElementsEnum);
	iomodel->Constant(&control_analysis,ControlAnalysisEnum);
	iomodel->Constant(&num_control_type,NumControlTypeEnum);

	/*Now, return if no control*/
	if (!control_analysis) return;

	/*Fetch data needed: */
	iomodel->FetchData(1,ElementsEnum);
	iomodel->FetchDataToInput(elements,VxObsEnum);
	iomodel->FetchDataToInput(elements,VyObsEnum); 
	iomodel->FetchDataToInput(elements,ThicknessObsEnum);

	iomodel->FetchData(4,ControlTypeEnum,WeightsEnum,CmMinEnum,CmMaxEnum);
	for(i=0;i<num_control_type;i++){
		switch((int)iomodel->Data(ControlTypeEnum)[i]){
			case DhdtEnum: iomodel->FetchData(1,DhdtEnum); break;
			case VxEnum:   iomodel->FetchData(1,VxEnum); break;
			case VyEnum:   iomodel->FetchData(1,VyEnum); break;
			case FrictionCoefficientEnum: iomodel->FetchData(1,FrictionCoefficientEnum); break;
			case RheologyBbarEnum:    iomodel->FetchData(1,RheologyBEnum); break;
			default: _error_("Control %s not implemented yet",EnumToStringx((int)iomodel->Data(ControlTypeEnum)[i]));
		}
	}

	/*Update elements and materials: */
	counter=0;
	for (i=0;i<numberofelements;i++){
		if(iomodel->my_elements[i]){
			element=(Element*)elements->GetObjectByOffset(counter);
			element->InputUpdateFromIoModel(i,iomodel); //we need i to index into elements.

			material=(Material*)materials->GetObjectByOffset(counter);
			material->InputUpdateFromIoModel(i,iomodel); //we need i to index into elements.
			counter++;
		}
	}
	
	/*Free data: */
	iomodel->DeleteData(1+4+5,ElementsEnum,ControlTypeEnum,WeightsEnum,CmMinEnum,CmMaxEnum,DhdtEnum,VxEnum,VyEnum,FrictionCoefficientEnum,RheologyBEnum);
}
