md=mesh(model,'../Exp/Square.exp',150000);
md=geography(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md=setelementstype(md,'macayeal','all');
md.cluster=generic('name',oshostname(),'np',3);
md.rho_ice=10^7; %involved in the mass flux, make it easy
md.thickness(:)=1; %make it easy

%constrain all velocities to 1 m/yr, in the y-direction
md.spcvx(:)=0;
md.spcvy(:)=1;
md.spcvz(:)=0;

%Dakota options
md.variables.drag_coefficient=normal_uncertain('scaled_FrictionCoefficient',1,0.01);

md.responses.MaxVel=response_function('MaxVel',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);
md.responses.MassFlux1=response_function('indexed_MassFlux_1',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);
md.responses.MassFlux2=response_function('indexed_MassFlux_2',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);
md.responses.MassFlux3=response_function('indexed_MassFlux_3',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);
md.responses.MassFlux4=response_function('indexed_MassFlux_4',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);
md.responses.MassFlux5=response_function('indexed_MassFlux_5',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);
md.responses.MassFlux6=response_function('indexed_MassFlux_6',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);

%mass flux profiles
md.qmu_mass_flux_profiles={'../Exp/MassFlux1.exp','../Exp/MassFlux2.exp','../Exp/MassFlux3.exp','../Exp/MassFlux4.exp','../Exp/MassFlux5.exp','../Exp/MassFlux6.exp'};
md.qmu_mass_flux_profile_directory=pwd;


%%  nond_sampling study

md.qmu_method     =dakota_method('nond_samp');
md.qmu_method(end)=dmeth_params_set(md.qmu_method(end),...
'seed',1234,...
'samples',20,...
'sample_type','lhs');

%%  a variety of parameters
md.qmu_params.evaluation_concurrency=1;
md.qmu_params.analysis_driver='';
md.qmu_params.analysis_components='';

%partitioning
md.npart=20;
md=partitioner(md,'package','chaco','npart',md.npart,'weighting','on');
md.part=md.part-1;
md.dakota_analysis=1;

md.eps_rel=10^-5; %tighten for qmu analyses

md=solve(md,DiagnosticSolutionEnum,'overwrite','y');

%Fields and tolerances to track changes
md=tres(md,'dakota');

%ok, mass flux of 3 profiles should be -3 Gt/yr -3 Gt/yr and the sum, which is -6 Gt/yr
%we recover those mass fluxes through the mean of the response.
%also, we recover the max velo, which should be 1m/yr. 
%we put all that data in the montecarlo field, which we will use to test for success.
%also, check that the stddev are 0.
md.results.dakota.montecarlo=[];
for i=1:7,
	md.results.dakota.montecarlo=[md.results.dakota.montecarlo md.results.dakota.dresp_out(i).mean];
end
for i=1:7,
	md.results.dakota.montecarlo=[md.results.dakota.montecarlo md.results.dakota.dresp_out(i).stddev];
end
field_names     ={'montecarlo'};
field_tolerances={1e-11};
field_values={...
         md.results.dakota.montecarlo,...
	};
