/*!\file: CreateParametersThermal.cpp
 * \brief driver for creating parameters dataset, for diagnostic horiz analysis.
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParametersThermal"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../Model.h"

void CreateParametersThermal(DataSet** pparameters,Model* model,ConstDataHandle model_handle){
	
	Param*   param = NULL;
	DataSet* parameters=NULL;
	int      count;
	int i;

	double* vx=NULL;
	double* vy=NULL;
	double* vz=NULL;
	double* u_g=NULL;
	double* pressure=NULL;
	double* temperature=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	count=parameters->Size();

	/*Get vx vy and vz: */
	ModelFetchData((void**)&vx,NULL,NULL,model_handle,"vx","Matrix","Mat");
	ModelFetchData((void**)&vy,NULL,NULL,model_handle,"vy","Matrix","Mat");
	ModelFetchData((void**)&vz,NULL,NULL,model_handle,"vz","Matrix","Mat");

	u_g=(double*)xcalloc(model->numberofnodes*3,sizeof(double));

	if(vx) for(i=0;i<model->numberofnodes;i++)u_g[3*i+0]=vx[i]/model->yts;
	if(vy) for(i=0;i<model->numberofnodes;i++)u_g[3*i+1]=vy[i]/model->yts;
	if(vz) for(i=0;i<model->numberofnodes;i++)u_g[3*i+2]=vz[i]/model->yts;

	count++;
	param= new Param(count,"u_g",DOUBLEVEC);
	param->SetDoubleVec(u_g,3*model->numberofnodes,3);
	parameters->AddObject(param);

	xfree((void**)&vx);
	xfree((void**)&vy);
	xfree((void**)&vz);
	xfree((void**)&u_g);
	
	/*Get pressure: */
	ModelFetchData((void**)&pressure,NULL,NULL,model_handle,"pressure","Matrix","Mat");
	
	count++;
	param= new Param(count,"p_g",DOUBLEVEC);
	if(pressure) param->SetDoubleVec(pressure,model->numberofnodes,1);
	else param->SetDoubleVec(pressure,0,0);
	parameters->AddObject(param);

	/*Free pressure: */
	xfree((void**)&pressure);

	/* get initial temperature and melting if transient*/
	if(strcmp(model->sub_analysis_type,"transient")==0){

		/*Get melting and temperature: */
		ModelFetchData((void**)&temperature,NULL,NULL,model_handle,"temperature","Matrix","Mat");

		count++;
		param= new Param(count,"t_g",DOUBLEVEC);
		if(temperature) param->SetDoubleVec(temperature,model->numberofnodes,1);
		else throw ErrorException(__FUNCT__,exprintf("Missing initial temperature"));
		parameters->AddObject(param);

		/*Free temperature: */
		xfree((void**)&temperature);
	}
	
	/*Assign output pointer: */
	*pparameters=parameters;
}
