%SURFACEFORCING Class definition
%
%   Usage:
%      surfaceforcings=surfaceforcings();

classdef surfaceforcings
	properties (SetAccess=public) 
		accumulation_rate = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		ablation_rate     = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		mass_balance      = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
	end
	methods
		function obj = surfaceforcings(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end
		end % }}}
	end
end
