function newresults=processresults(models,results);
%PROCESSRESULTS - process results from core solution
%
%   The solution (vel,pressure,...) are on the g-set,
%   use index to get the value on each node
%
%   Usage:
%      results=processresults(md,results,m_dh,m_ds,m_dhu)

%recover models
m_dh=models.dh;
m_ds=models.ds;
m_dhu=models.dhu;

%recover parameters
debug=m_dhu.parameters.debug;
dim=m_dhu.parameters.dim;
ishutter=m_dhu.parameters.ishutter;
ismacayealpattyn=m_dh.parameters.ismacayealpattyn;
isstokes=m_ds.parameters.isstokes;
yts=m_ds.parameters.yts;

%recover results
u_g=results.u_g;
p_g=results.p_g;

newresults=struct();
if dim==2,
	newresults.step=1;
	newresults.time=1;
	newresults.vx=u_g(1:2:end)*yts;
	newresults.vy=u_g(2:2:end)*yts;
	newresults.vel=sqrt(newresults.vx.^2+newresults.vy.^2);
	newresults.pressure=p_g;

else
	
	newresults.step=1;
	newresults.time=1;
	if isstokes,
		newresults.vx=u_g(1:4:end)*yts;
		newresults.vy=u_g(2:4:end)*yts;
		newresults.vz=u_g(3:4:end)*yts;
		newresults.pressure=p_g;
	else
		newresults.vx=u_g(1:3:end)*yts;
		newresults.vy=u_g(2:3:end)*yts;
		newresults.vz=u_g(3:3:end)*yts;
		newresults.pressure=p_g;
	end
	newresults.vel=sqrt(newresults.vx.^2+newresults.vy.^2+newresults.vz.^2);
end
