function converged=convergence(K_ff,p_f,u_f,u_f_old,parameters)

%before we start, check that u_f actually holds values, otherwise, we are done converging
if isempty(u_f), converged=true;  return; end

%Get convergence options
yts=parameters.ConstantsYts;
eps_res=parameters.EpsRes;
eps_rel=parameters.EpsRel;
eps_abs=parameters.EpsAbs;

%initialization
converged=false;

%Display solver caracteristics
if (VerboseConvergence()),
	solver_res=norm(K_ff*u_f-p_f,2)/norm(p_f,2);
	issmprintf(VerboseConvergence(),'%s%g','      condition number of stiffness matrix: ',condest(K_ff));
	issmprintf(VerboseConvergence(),'%s%g','      solver residue: norm(KU-F)/norm(F)=',solver_res);
end

%Force equilibrium (Mandatory)
res=norm(K_ff*u_f_old-p_f,2)/norm(p_f,2);
if isnan(res),
	error('convergence error message: mechanical equilibrium convergence criterion is NaN!'); 
end
if (res<=eps_res),
	issmprintf(VerboseConvergence(),'%-60s%g%s%g%s','      mechanical equilibrium convergence criterion',res*100,' < ',eps_res*100,' %');
	converged=true;
else
	issmprintf(VerboseConvergence(),'%-60s%g%s%g%s','      mechanical equilibrium convergence criterion',res*100,' > ',eps_res*100,' %');
	converged=false;
end

%Relative criterion (optional)
if ((~isnan(eps_rel)) | (VerboseConvergence())),

	%compute ndu/nu
	duf=u_f-u_f_old;
	ndu=norm(duf,2); 
	nu=norm(u_f_old,2); 
	if isnan(ndu),
		error('convergence error message: relative convergence criterion is NaN!'); 
	end

	%print criterion
	if ~isnan(eps_rel),
		if nu, %avoid "dividing by zero" warning
			if (ndu/nu<=eps_rel),
				issmprintf(VerboseConvergence(),'%-60s%g%s%g%s','      relative convergence criterion: norm(du)/norm(u)',ndu/nu*100,' < ',eps_rel*100,' %');
			else
				issmprintf(VerboseConvergence(),'%-60s%g%s%g%s','      relative convergence criterion: norm(du)/norm(u)',ndu/nu*100,' > ',eps_rel*100,' %');
				converged=false;
			end
		else
			converged=false;
		end
	else
		if nu, %avoid "dividing by zero" warning
			issmprintf(VerboseConvergence(),'%-60s%g%s','      relative convergence criterion: norm(du)/norm(u)',ndu/nu*100,' %');
		end
	end

end

%Absolute criterion (optional)
if ((~isnan(eps_abs)) | VerboseConvergence()),

	%compute max(du)
	duf=u_f-u_f_old;
	nduinf=norm(duf,inf)*yts; 
	if isnan(nduinf),
		error('convergence error message: absolute convergence criterion is NaN!'); 
	end

	%print criterion
	if ~isnan(eps_abs),
		if (nduinf<=eps_abs),
			issmprintf(VerboseConvergence(),'%-60s%g%s%g%s','      absolute convergence criterion: max(du)',nduinf,' < ',eps_abs,' m/yr');
		else
			issmprintf(VerboseConvergence(),'%-60s%g%s%g%s','      absolute convergence criterion: max(du)',nduinf,' > ',eps_abs,' m/yr');
			converged=false;
		end
	else
		issmprintf(VerboseConvergence(),'%-60s%g%s','      absolute convergence criterion: max(du)',nduinf,' m/yr');
	end

end
